#include <iostream>
#include <iomanip>
#include <string>
#include <fstream>
#include <vector>
#include <list>
#include <algorithm>


#include "book.h"
#include "move.h"
#include "defs.h"
#include "board.h"
#include "material.h"
#include "movelist.h"
#include "history.h"
#include "fen.h"
#include "movegen.h"
#include "make.h"
#include "log.h"


using namespace std;

cBookmake::cBookmake()
{
    bookoptions.outfile="default.bin";
    bookoptions.setout=0;
    bookoptions.pgnfile="nofile.pgn";
    bookoptions.setexist=0;
    bookoptions.addtobook=0;
    bookoptions.countmoves=-1;
    bookoptions.plydepth=28;
    bookoptions.existingbook="";
}

void cBookmake::readbook()
{
    S_bookentry temp;
    ifstream fin(bookoptions.outfile.c_str(), ios::binary);
    if(!fin) { cout<<"\nno bookfile\n"; return;}
    booklines.clear();

    while (!fin.eof())
    {
      fin.read((char *) &temp, sizeof(temp));
      booklines.push_back(temp);
    }

    cout<<"\n read in "<<booklines.size()<<" book entries \n";

    fin.close();
}

//reading an existing book into the list in readpgn()
void cBookmake::readlist(list<S_bookentry> &list)
{
    S_bookentry temp;
    ifstream fin(bookoptions.existingbook.c_str(), ios::binary);
    if(!fin) { cout<<"\nno current book -> "<<bookoptions.existingbook<<"\n"; return;}

    while (!fin.eof())
    {
      fin.read((char *) &temp, sizeof(temp));
      list.push_back(temp);
    }

    cout<<"\n read in "<<list.size()<<" book entries from "<<bookoptions.existingbook<<"\n";
    fin.close();
}


void cBookmake::getbookoptions()
{
    string spare;
    cout<<"\n Welcome to Lime bookmaker... !! :) ";
    if(bookoptions.plydepth<1) {bookoptions.plydepth=28;}
    if(bookoptions.plydepth>maxply) {bookoptions.plydepth=maxply;}
    if(bookoptions.countmoves<0) bookoptions.countmoves=0;
    if(bookoptions.addtobook!=0 && bookoptions.addtobook!=1)
    {
        bookoptions.addtobook=0;
    }
    if(bookoptions.addtobook==1)
    {
        bookoptions.setout = 1;
        cout<<"\n adding to book option file "<<bookoptions.existingbook;
        if(!bookoptions.setexist)
        {
            cout<<" but no existing option set ";
            if(bookoptions.setout) bookoptions.existingbook = bookoptions.outfile;
            else bookoptions.existingbook = "default.bin";
        }
        if(bookoptions.outfile != bookoptions.existingbook)
        {
          bookoptions.outfile = bookoptions.existingbook;
        }
    }
    if(!bookoptions.setout) bookoptions.outfile = "default.bin";
    cout<<"\npgn data: "<<bookoptions.pgnfile;
    cout<<"\noutput file: "<<bookoptions.outfile;
    if(bookoptions.addtobook==1) cout<<" (append to existing)";
    cout<<"\nsetting count "<<bookoptions.countmoves;
    cout<<"\nsetting depth "<<bookoptions.plydepth;
}


bool cBookmake::makesan(const string make)
{
    if(make=="1/2-1/2" || make=="0-1" || make=="1-0" || make=="*" || make == " ")
    return false;
    pboard.setply(0);
    uint move;
    string made;
    move = santomove(make,pboard, mat);
    makemove(pboard,mat,his,move);
    return true;
}


void cBookmake::writebook(list<S_bookentry> &bookentries)
{
    if(!bookentries.size()) return;
    unsigned int c;
    vector<S_bookentry> finallist;

    for(list<S_bookentry>::iterator iter = bookentries.begin(); iter != bookentries.end(); ++iter)
    {
       if(iter->count >= bookoptions.countmoves)
        {
            finallist.push_back((*iter));
        }
    }
    cout<<"\ntrimmed to "<<finallist.size()<<" entries ";

    ofstream fout(bookoptions.outfile.c_str(), ios::binary | ios::app);
     for(c=0; c < finallist.size(); ++c)
     {
         fout.write((char *)(&finallist[c]), sizeof(S_bookentry));
     }

     fout.close();
}

void cBookmake::addentry(list<S_bookentry> &l, const S_bookentry &temp)
{
    //int c,d;
    for(list<S_bookentry>::iterator iter = l.begin(); iter != l.end(); ++iter)
    {
            if(iter->key==temp.key && iter->move==temp.move)
            {
                iter->count++;return;
            }
    }
    //entry is new, so add it
    l.push_back(temp);
}

void cBookmake::readpgn()
{
    getbookoptions();
    string movetomake; //the move that will be pushed back into the vector
    int countmoves=0;
    int countgames=0;
    string lines;//string reading in each line of the pgn file
    string gameline;//will conatin the whole game line as one strip
    ifstream file;//pgn file
    int found = -1;//set to 0 when we find the start of a game (string starts 1.)
    string::iterator pline = lines.begin();//iterate through the line
    file.open(bookoptions.pgnfile.c_str());//open the pgn file
    S_bookentry tempentry;
    list<S_bookentry> bookentries;
    sRecord *hist = his.p2history();

    //if we're adding to an existing book, we need to read this into the list
    if(bookoptions.addtobook==1)
    {
        readlist(bookentries);
        remove(bookoptions.existingbook.c_str());
    }

    bool ingame = false;
    bool lastline = false;
    if(!file)
    {
        cout<<"\nNo "<<bookoptions.pgnfile<<" found !!";
        //if we're adding to an existing book, write the stored entries back to the file
        writebook(bookentries);
        return;
    }
    if (file.is_open())
    {
      while (! file.eof() )
      {
       getline (file,lines);
       if(lines[0]=='[')
       {
          // cout<<"\n header ";
           continue;
       }
       if(!ingame)//if we're not in a game, see if we've started the next game
       {
        found=lines.find("1.",0,2);
        if(found==0)
        {
           // cout<<"starting game ";
            //if(countmoves<21) cout<<"\n last game less than 20";
            setepdposition(startfen,pboard,mat,his);
            his.clearhistory();
            ingame=true;
            countgames++;
            countmoves=0;
            if(countgames%100==0) cout<<"\n---> game "<<countgames;
            if(countgames%10==0) cout<<" . ";
            gameline.clear();
        }// now in a game
       }
       else // we're in a game - is this the last line?
       {
        found=lines.find("0-1",0,3);
        if(found==-1) found=lines.find("1-0",0,3);
        if(found==-1) found=lines.find("1/2-1/2",0,7);
        if(found==-1) found=lines.find("*",0,1);
        if(found!=-1) lastline=true;
       }
       if(ingame) //game move now started, now store iterate and make moves
       {
         //if the new line doesn't start with a space, make sure there's a space put in if the last one didn't end with
         //a space - don't do this if we're processing the first line!
         if(!(lines[0]=='1' && lines[1]=='.'))
         {
             if(gameline[gameline.length()-1] != ' ')
             {
                 if(lines[0]!=' ')
                 {
                    gameline+=" ";
                 }
             }
         }
         gameline+=lines;
         if(!lastline) {continue;}
       //  cout<<"\nGame  "<<countgames<<" \n"<<gameline<<endl;
         ingame=false;
         lastline=false;
         pline = gameline.begin();
         while(pline != gameline.end())
         {
               movetomake.clear();
               //printboard();
               if(pline[0]=='.')//hit dot indicating move for white
               {
                *pline++;
                if(pline[0]==' ') *pline++;//if there's a space after the dot, move to next
             //   cout<<"\n here 1";
                while(pline[0] != ' ')
                {
                    movetomake += pline[0];
                    *pline++;
                }
             //   cout<<"\n here 2";
             //   pboard.printboard();
            //    cout<<"\n pgn -----> white making "<<movetomake<<endl;
                if(!makesan(movetomake))
                {
                  //  cout<<" wbreaking "<<countgames;
                    break;
                }
                 tempentry.move=hist[his.getmoves()-1].move;
                 tempentry.key=hist[his.getmoves()-1].key;
                 tempentry.count=0;
                 addentry(bookentries,tempentry);

                countmoves++;
             //   system("PAUSE");
             //   cout<<"\n here 3";
                *pline++;//should be looking at the first letter of the black move..
                movetomake.clear();
             //   cout<<"\n here 4";
                while(pline[0] != ' ')
                {
                  // cout<<" adding "<<pline[0];
                    movetomake += pline[0];
                    *pline++;
                    if(!*pline)
                    {
                      break;
                    }
                }
           //     cout<<"\n here 5";
      //     pboard.printboard();
            //    cout<<"\n pgn -----> black making "<<movetomake<<endl;
                if(!makesan(movetomake))
                {
                   // printboard();
                  // cout<<" bbreaking ";
                    break;
                }
                tempentry.move=hist[his.getmoves()-1].move;
                 tempentry.key=hist[his.getmoves()-1].key;
                 tempentry.count=0;
                 addentry(bookentries,tempentry);
                countmoves++;
                if(countmoves > bookoptions.plydepth)
                {break;}
            //    system("PAUSE");
            //    cout<<"\n here 6";
               }
             //  cout<<"\n pline = "<<*pline;
               *pline++;
         }
       }
      }
      file.close();
    }
    else
    {
        cout<<"\n File book.pgn not found";
    }

    cout<<"\n found "<<bookentries.size()<<" entries ";

    //now, loop through the bookentries vector, counting entries of the same type -
    writebook(bookentries);
    bookentries.clear();
}

cBookread::cBookread()
{
  fileexists = false;
}

void cBookread::init_book()
{
    bookfile.open(bookname.c_str(), ios::binary|ios::in|ios::ate);

    if(!bookfile.is_open())
    {
        if(logger.islog())
        {
            logger.file<<"book file ["<<bookname<<"] was not found\n";
        }
        cout<<"book file ["<<bookname<<"] was not found\n";
        fileexists = false;
        return;
    }

    int size;
    size = (int)bookfile.tellg();
    int entries;
    entries = size / sizeof(S_bookentry);

    if(logger.islog()) logger.file << "book file size "<<size<<endl;
    cout << "book file size "<<size<<endl;
    if(logger.islog()) logger.file << "num book entries "<<entries<<endl;
    cout << "num book entries "<<entries<<endl;

    bookfile.seekg (0, ios::beg);

    whitemoves.clear();

    S_bookentry temp;

    for(int i = 0; i < entries; ++i)
    {
       bookfile.seekg(i, ios::beg);
       bookfile.read((char*)&temp, sizeof(S_bookentry));
       whitemoves.push_back(temp);
    }

    ASS(whitemoves.size()==entries);

    if(logger.islog()) logger.file << "read in "<<whitemoves.size()<<" entries into internal store "<<endl;
    cout << "read in "<<whitemoves.size()<<" entries into internal store "<<endl;

    bookfile.close();

    if(logger.islog()) logger.file.flush();

}

void cBookread::setbookuse(bool use)
{
     fileexists=use;
}

bool comparecount(const S_bookentry &one, const S_bookentry &two)
{
        return (one.count > two.count);
}

bool cBookread::bookmove(u64 key, uint &move)
{
    int size = whitemoves.size();
    if(size<1)
    {
        move = NULLMOVE;
        if(logger.islog()) logger.file<<" no book move found\n";
        return false;
    }

    vector<S_bookentry> entries;
    int count;
    u64 sparekey;
    int index;
    for(int index=0; index<size; ++index)
    {
        sparekey = whitemoves[index].key;
        if(sparekey == key) entries.push_back(whitemoves[index]);
    }

    if( entries.size() == 0) return false;

    if(logger.islog()) logger.file<<" found "<<entries.size()<<" book moves\n";

    sort(entries.begin(), entries.end(), comparecount);

    for (index = 0; index < entries.size(); index++)
    {
        if(logger.islog())
        {
           logger.file<<"\n book moves : ";
           logger.file<<printmove(entries[index].move);
           logger.file<<" count "<<entries[index].count<<endl;
        }
    }

    //random pick from top 4 entries

    uint seed = uint(clock());

    srand(seed);

    int randompick = entries.size();
    if(randompick > 4) randompick = 4;

    int position = rand() % randompick;
    ASS(position >=0 && position <=3);

    move = entries[position].move;

    return true;
}







